VERSION 5.00
Begin VB.Form frmTrackerParameters 
   Caption         =   "Tracker Parameters"
   ClientHeight    =   4110
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   6195
   Icon            =   "TrackerParameters.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4110
   ScaleWidth      =   6195
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraAlgorithm 
      Caption         =   "Choose an Algorithm"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   0
      TabIndex        =   21
      Top             =   120
      Width           =   2655
      Begin VB.ComboBox cmbAlgorithm 
         Height          =   315
         ItemData        =   "TrackerParameters.frx":0CCA
         Left            =   360
         List            =   "TrackerParameters.frx":0CD4
         Sorted          =   -1  'True
         TabIndex        =   22
         Text            =   "No Algorithm Loaded"
         ToolTipText     =   "Select an Algorithm."
         Top             =   360
         Width           =   2175
      End
   End
   Begin VB.Frame fraParameters 
      Caption         =   "Parameters"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3975
      Left            =   2760
      TabIndex        =   0
      Top             =   120
      Width           =   3375
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   9
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   20
         Text            =   "not used"
         Top             =   3600
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   8
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   19
         Text            =   "not used"
         Top             =   3240
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   7
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   18
         Text            =   "not used"
         Top             =   2880
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   6
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   17
         Text            =   "not used"
         Top             =   2520
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   5
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   16
         Text            =   "not used"
         Top             =   2160
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   4
         Left            =   2500
         Locked          =   -1  'True
         MaxLength       =   64
         TabIndex        =   15
         Text            =   "not used"
         Top             =   1800
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   3
         Left            =   2500
         MaxLength       =   64
         TabIndex        =   14
         Text            =   "not used"
         Top             =   1440
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   2
         Left            =   2500
         MaxLength       =   64
         TabIndex        =   13
         Text            =   "not used"
         Top             =   1080
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   1
         Left            =   2500
         MaxLength       =   64
         TabIndex        =   12
         Text            =   "not used"
         Top             =   720
         Width           =   735
      End
      Begin VB.TextBox txtParameterValue 
         Alignment       =   1  'Right Justify
         Height          =   285
         Index           =   0
         Left            =   2500
         MaxLength       =   64
         TabIndex        =   2
         Text            =   "not used"
         Top             =   360
         Width           =   735
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "10th Parameter"
         Height          =   255
         Index           =   9
         Left            =   255
         TabIndex        =   11
         Top             =   3600
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "9th Parameter"
         Height          =   255
         Index           =   8
         Left            =   255
         TabIndex        =   10
         Top             =   3240
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "8th Parameter"
         Height          =   255
         Index           =   7
         Left            =   255
         TabIndex        =   9
         Top             =   2880
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "7th Parameter"
         Height          =   255
         Index           =   6
         Left            =   255
         TabIndex        =   8
         Top             =   2520
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "6th Parameter"
         Height          =   255
         Index           =   5
         Left            =   255
         TabIndex        =   7
         Top             =   2160
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "5th Parameter"
         Height          =   255
         Index           =   4
         Left            =   255
         TabIndex        =   6
         Top             =   1800
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "4th Parameter"
         Height          =   255
         Index           =   3
         Left            =   255
         TabIndex        =   5
         Top             =   1440
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "3rd Parameter"
         Height          =   255
         Index           =   2
         Left            =   255
         TabIndex        =   4
         Top             =   1080
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "2nd Parameter"
         Height          =   255
         Index           =   1
         Left            =   255
         TabIndex        =   3
         Top             =   720
         Width           =   2145
      End
      Begin VB.Label lblParameter 
         Alignment       =   1  'Right Justify
         Caption         =   "1st Parameter"
         Height          =   255
         Index           =   0
         Left            =   255
         TabIndex        =   1
         Top             =   360
         Width           =   2145
      End
   End
   Begin VB.Menu mnuParameters 
      Caption         =   "&Parameters"
      Begin VB.Menu mnuLoadProfile 
         Caption         =   "&Load Profile..."
         Shortcut        =   ^L
      End
      Begin VB.Menu mnuSave 
         Caption         =   "&Save as..."
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuRename 
         Caption         =   "&ReName..."
         Shortcut        =   ^R
      End
      Begin VB.Menu mnuspace0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuDelete 
         Caption         =   "&Delete..."
      End
      Begin VB.Menu mnuspace1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuApplyParameters 
         Caption         =   "Apply Parameters"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuClose 
         Caption         =   "Close"
         Shortcut        =   ^W
      End
   End
End
Attribute VB_Name = "frmTrackerParameters"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This form is used to enter configuration settings for the tracker algorithm.
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Private configuration As New GeneralConfigurationClass

Private noComboClick As Boolean

Private Sub cmbAlgorithm_Click()

On Error GoTo oops:
If noComboClick Then Exit Sub ' turns off event for comboclick while loading form
  
  Dim i As Integer
  
  For i = txtParameterValue.LBound To txtParameterValue.UBound
    txtParameterValue(i).text = DefaultParameterValues(cmbAlgorithm.ListIndex, i)
  Next i
  
  If FormIsValid Then
    Set configuration = FormRead
    FormFill                          ' needed to make boxes visible
    ConfigureControlProperties
  End If
  Exit Sub
   
oops:
  ErrorBox
  
End Sub
 
Private Function DefaultParameterValues(algorithm As Integer, _
                                      parameter As Integer) As Variant
  
  On Error GoTo oops:
  
  Select Case algorithm
    Case ALPHABETA
      Select Case parameter
      Case 0 + txtParameterValue.LBound
        DefaultParameterValues = 0.6
      Case 1 + txtParameterValue.LBound
        DefaultParameterValues = 0.6
      Case 2 + txtParameterValue.LBound
        DefaultParameterValues = 2
      Case Else
        DefaultParameterValues = "not used"
      End Select
    Case JPDA
      Select Case parameter
      Case 0 + txtParameterValue.LBound
        DefaultParameterValues = 0.2
      Case 1 + txtParameterValue.LBound
        DefaultParameterValues = 0.9
      Case 2 + txtParameterValue.LBound
        DefaultParameterValues = 4
      Case 3 + txtParameterValue.LBound
        DefaultParameterValues = 0.95
      Case 4 + txtParameterValue.LBound
        DefaultParameterValues = 0.1
      Case Else
        DefaultParameterValues = "not used"
      End Select
    Case Else
      Debug.Assert (False)
      DefaultParameterValues = 0
  End Select
  
  Exit Function
  
oops:
  ErrorBox
  
End Function

Private Function LastUsedProfile() As Boolean

  On Error GoTo oops:
  
  configuration.SetConfigType trackParametersTC ' just for safety's sake!
  configuration.LastUsedProfile Me
  
  Exit Function
  
oops:
  ErrorBox
  
End Function

Private Sub mnuApplyParameters_Click()
  
  On Error GoTo oops:
  
  configuration.Apply Me, general.trackerParameter
  ConfigureControlProperties
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub mnuClose_Click()
 
  On Error GoTo oops:
  
  configuration.CloseForm Me
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub mnuDelete_Click()
  
  On Error GoTo oops:
  
  configuration.DeleteProfile Me
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub mnuLoadProfile_Click()

  On Error GoTo oops:
  
  configuration.SetConfigType trackParametersTC
  If Not configuration.LoadProfile(Me) Then _
    MsgBox "Couldn't load profile with name = " & configuration.GetValue("name") & ", sorry!", , _
            "Attempt to load a display profile failed..."
  
  Exit Sub
  
oops:
  ErrorBox
    
End Sub

Private Sub mnuParameters_Click()
  
  On Error GoTo oops:
  If noComboClick Then Exit Sub
  
  ConfigureControlProperties

  Exit Sub

oops:
  ErrorBox
  
End Sub

Private Sub mnuRename_Click()

  On Error GoTo oops:
  
  configuration.Rename Me
  general.propertyList.SetProperty configuration.PropertyName, _
                                            configuration.GetValue("name")
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub mnuSave_Click()
  
  On Error GoTo oops:
  
  If Not FormIsValid Then
    MsgBox "The contents of the form are not a valid configuration." & _
                            vbCrLf & "The configuration could not be saved."
    Exit Sub
  Else
    Set configuration = FormRead
    configuration.SaveAs Form:=Me
    
  End If
                                           
  Exit Sub
  
oops:
  ErrorBox
  
End Sub
 
Private Function FormIsValid() As Boolean

  On Error GoTo oops:
    
  FormIsValid = False         ' The form is invalid unless "proven innocent".
    
  Dim testConfiguration As New GeneralConfigurationClass
  Set testConfiguration = FormRead
  FormIsValid = ValidateProfile(testConfiguration)

  Exit Function

oops:
  ErrorBox
  FormIsValid = False
  
End Function

Public Sub ConfigureControlProperties()

  On Error GoTo oops:
  
  ConfigureMenus
  ConfigureFrames
  ConfigureLabels
  
  If configuration Is Nothing Then
    Me.caption = "Tracker Parameters: No Profile Loaded"
  Else
    Me.caption = "Tracker Parameters:  Profile '" & Right(configuration.GetValue("name"), 16) & "'"
    Me.caption = Me.caption & IIf(NotApplied, " - Not Applied", " - Applied")
  End If
  
  Exit Sub
  
oops: ' ON the first error, just try to muddle through...
  ErrorBox "Difficulties were encountered while configuring form controls. (Sorry)" _
            & vbCrLf & "Suggestion->" & vbCrLf & _
            "Try loading the 'default' profile, applying it, and then closing and re-opening this form."
  On Error GoTo oops2:
  Resume Next
  
  Exit Sub
  
oops2: ' just quit
  StoreError
  
End Sub

Public Sub SetupForm()

  On Error GoTo oops:
    
0 LastUsedProfile ' note - if this fails then setup should stop
2 FormFill
5 ConfigureControlProperties


  Me.Show 0
  Exit Sub

oops:
  Select Case Erl
    Case 0
      ErrorBox "Couldn't load the last used profile. (Sorry.)"
      Resume Next
    Case 2
      ErrorBox "Was unable to enter parameters into the form. (Sorry.)"
      Resume Next
    Case 5
      ErrorBox "Was unable to properly configure form control properties. (Sorry.)"
      Resume Next
    Case Else ' this shouldn't happen
      Debug.Assert (False)
      ErrorBox "An unexpected error occured."
  End Select
  
End Sub

Private Function FormRead() As GeneralConfigurationClass

  On Error GoTo oops:
  
reentry:
  Dim newConfiguration As GeneralConfigurationClass
  Set newConfiguration = configuration.Clone

  On Error GoTo oops2:
  
    ' ReadParameters
  Dim index As Integer
  Dim good As Boolean
  
  ' ReadAlgorithm
  newConfiguration.SetValue "tracker", Format(cmbAlgorithm.ListIndex)
   
  For index = 0 To 9
    If IsNumeric(txtParameterValue(index).text) Then _
      txtParameterValue(index).text = Format(Val((txtParameterValue(index).text)))
    newConfiguration.SetValue ("parameter" & (index + 1)), (txtParameterValue(index).text)
  Next index
  
  Set FormRead = newConfiguration.Clone

  Exit Function
  
oops:
  ErrorBox
  On Error GoTo justquit:
  Resume reentry:
  Exit Function ' don't really need exit here but doing out of habit
  
oops2:
  If Err.Source = "GeneralConfigurationClass.SetValue" Then
    ErrorBox "Was unable to read a form value ('" & key & "') into the profile due to an error."
  Else
    Select Case Err.number
      Case VALUE_NOT_SET_ERROR
        ' let it fall through...
      Case 340 ' control array element does not exist
        Resume Next
      Case Else
        ' let it fall through...
    End Select
    ErrorBox
  End If
  Exit Function
  
justquit:    ' just quit
  ErrorBox
  
End Function

Private Sub ConfigureMenus()

    ' apply - can only apply if there has bee a change since applying and the change is saved.
    ' save - can only save if the form has been changed
 
  On Error GoTo oops:
  
  mnuApplyParameters.enabled = NotApplied
  mnuSave.enabled = modifiedSinceSave
  mnuRename.enabled = Not modifiedSinceSave
  
    ' the other mnu items don't change...
  Exit Sub
  
oops:
  StoreError
  MyStoredError.Raise eSource:=Me.name & ".ConfigureMenus"
  
End Sub

Private Sub FillCombo()

  On Error GoTo oops:
  
  noComboClick = True    ' turns off event for comboclick while loading form
  cmbAlgorithm.ListIndex = configuration.GetValue("tracker")
  noComboClick = False   ' turns on event for comboclick after loading form
  
  Exit Sub
  
oops:
  Dim prompt As String
  StoreError
  ErrorBox IIf((MyStoredError.Source = "GeneralConfigurationClass.GetValue") _
                , "I was unable to get the stored value for the tracker algorithm." _
                , "I was unable to set the tracker algorithm.")

  noComboClick = False
  
End Sub

Private Sub FillParamBoxes()

  On Error GoTo oops:
  
  noComboClick = True
  Dim i As Integer
 
  For i = txtParameterValue.LBound To txtParameterValue.UBound
    key = "parameter" & (i + 1)
      ' make "not used" boxes invisible.
    If configuration.GetValue(key) = "not used" Then
      txtParameterValue(i).text = configuration.GetValue(key)
      txtParameterValue(i).visible = False
      lblParameter(i).visible = False
    Else
      ' make used boxes visible and put in the values
      txtParameterValue(i).text = configuration.GetValue(key)
      txtParameterValue(i).visible = True
      lblParameter(i).visible = True
    End If
  Next i
  noComboClick = False
  
  Exit Sub
  
oops:
  If Err.Source = "GeneralConfigurationClass.GetValue" Then
    If vbYes = ErrorBox("I wasn't able to get one of the parameter values ('key' = " & _
              key & ")... (sorry)" & vbCrLf & "Should I keep going???", , vbYesNo) Then Resume Next
  ElseIf Err.number = 340 Then
    ErrorBox "I think that I'm looking for the wrong number of parameter boxes...  :(" & vbCrLf & _
               "Please contact technical support. (Thank you.)"
  Else
    ErrorBox
  End If
  
End Sub

Private Sub ConfigureFrames()
  
  On Error GoTo oops:
  
  fraAlgorithm.caption = IIf(cmbAlgorithm.ListIndex = -1, "Last Used Algorithm", "Current Algorithm")
  
  ' adjust the size of the form and parameters frame to the number of visisble parameters
  fraParameters.height = 3975 - (10 - NumberOfParameters) * 360
  frmTrackerParameters.height = 4800 - (10 - NumberOfParameters) * 360
  If frmTrackerParameters.height < (4800 - (8) * 360) Then
    frmTrackerParameters.height = 4800 - (8) * 360 ' may want to set some other minimum value...
  End If
  
  Exit Sub
  
oops:
  fraParameters.height = 3975
  frmTrackerParameters.height = 4800
  ErrorBox

End Sub

Private Sub ConfigureLabels()

  ' sets up labels if/as needed
  On Error GoTo oops:
  
  Dim algorithm As Integer
  
  algorithm = Val(configuration.GetValue("tracker"))
  Select Case algorithm
    Case ALPHABETA  ' ab
      lblParameter(0).caption = "Alpha [velocity update]"
      lblParameter(1).caption = "Beta [position update]"
      lblParameter(2).caption = "Radius of Range Gate"
      
    Case JPDA  ' jpda + ab
      lblParameter(0).caption = "Alpha [velocity update]"
      lblParameter(1).caption = "Beta [position update]"
      lblParameter(2).caption = "Initial Gate Size [samples]"
      lblParameter(3).caption = "Probability of Detection"
      lblParameter(4).caption = "Extraneous Return Density"
      
    ' Case 2  ' Add here for additonal algorithms
    Case Else
      Err.Raise BADALGORITHM_ERROR, Me.name & ".ConfigureLabels", _
                MyStoredError.DescriptionOfError(BADALGORITHM_ERROR)
  End Select
  
  Exit Sub
  
oops:
  ErrorBox

End Sub

Public Function NumberOfParameters() As Integer  ' Done
    
    ' This function returns the number of parameters that should be
    ' visible to the user (# of user adjustable parameters.)

  On Error GoTo oops:

  Select Case cmbAlgorithm.ListIndex
    Case ALPHABETA
      NumberOfParameters = 3
    
    Case JPDA
      NumberOfParameters = 5
      
   ' case ###  - Add for additional algorithms here.
   
   Case Else
      Err.Raise BADALGORITHM_ERROR, Me.name & ".NumberOfParameters", _
                MyStoredError.DescriptionOfError(BADALGORITHM_ERROR)
  End Select
    
  Exit Function
  
oops:
  ErrorBox
  NumberOfParameters = (txtParameterValue.UBound - txtParameterValue.LBound) + 1 ' show all of the boxes

End Function

Public Function ValidateProfile(ByVal profile As _
                        GeneralConfigurationClass) As Boolean

  On Error GoTo oops:
  ValidateProfile = False
  
  Dim i As Integer
  Dim good As Boolean
  Dim key As String
  
  ' check type
  good = profile.ValidateStandardFields
  
  good = good And TextFieldValid(profile.GetValue("createdBy"), 1, 49)
  good = good And TextFieldValid(profile.GetValue("tracker"), 1, 49)
  
  If Not IsNumeric(profile.GetValue("tracker")) Then
    ValidateProfile = False
    Exit Function
  End If
  
  For i = (txtParameterValue.LBound + 1) To (txtParameterValue.UBound + 1)
    good = good And TextFieldValid(profile.GetValue("parameter" & i), 1, 49)
    good = good And IsTxtParamValid(profile.GetValue("tracker"), i - 1, profile.GetValue("parameter" & i))
  Next i

  ValidateProfile = good
  
  Exit Function
  
oops:
  ErrorBox
  ValidateProfile = False

End Function

Public Sub FormFill()

  On Error GoTo oops:
  
  FillParamBoxes
  FillCombo

  Exit Sub
  
oops:
  StoreError
  MyStoredError.Raise
  
End Sub

Private Sub txtParameterValue_Change(index As Integer)

  On Error GoTo oops:
  If noComboClick Then Exit Sub
  
  txtParameterValue(index).backcolor = vbWhite

  Exit Sub

oops:
  ErrorBox
  
End Sub

Private Sub txtParameterValue_GotFocus(index As Integer)
  
  On Error GoTo oops:
  If noComboClick Then Exit Sub
  
  TextboxSelectAll txtParameterValue(index), vbBlack, vbWhite
  Exit Sub

oops:
  ErrorBox
  
End Sub

Private Sub txtParameterValue_Validate(index As Integer, Cancel As Boolean)

  On Error GoTo oops:
  
  Cancel = False
  txtParameterValue(index).backcolor = vbWhite
  If IsNumeric(txtParameterValue(index)) Then txtParameterValue(index) = Format(Val(txtParameterValue(index))) ' cleans up test box entry
  If Not IsTxtParamValid(cmbAlgorithm.ListIndex, index, txtParameterValue(index), _
                                            lblParameter(index)) Then
    TextboxSelectAll txtParameterValue(index), vbBlack, vbYellow
    Cancel = True
  End If
  
  ConfigureControlProperties
  
  Exit Sub
  
oops:
  ErrorBox
  Cancel = True
  
End Sub

Public Function IsTxtParamValid(algorithm As Integer, index As Integer, _
          value As String, Optional label As String = "") As Boolean

  On Error GoTo oops
  Dim rtv As Boolean
  
  IsTxtParamValid = False
  
  If Len(value) > 15 Then Exit Function
  
  Select Case algorithm
    Case ALPHABETA ' JB's Alpha Beta Tracker
      Select Case index
        Case (0 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (1 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (2 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 400, , label)
        Case (3 + txtParameterValue.LBound) To txtParameterValue.UBound
          rtv = (value <> "")
        Case Else
          Debug.Assert False
      End Select
      
    Case JPDA ' JB's AB + JPDA
      Select Case index
        Case (0 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (1 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (2 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 400, , label)
        Case (3 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (4 + txtParameterValue.LBound)
          rtv = ValidateFloatString(value, 0, 1, , label)
        Case (5 + txtParameterValue.LBound) To txtParameterValue.UBound
          rtv = (value <> "")
        Case Else
          Debug.Assert False
      End Select
    
    ' case ###  - Add for additional algorithms here.
    
    Case Else
      Debug.Assert (False)
      Err.Raise BADALGORITHM_ERROR, Source:=Me.name & ".ValidateProfile", _
                        description:=MyStoredError.DescriptionOfError(BADALGORITHM_ERROR)
  End Select
  
  IsTxtParamValid = rtv
  Exit Function
  
oops:
  ErrorBox
  IsTxtParamValid = False
  If MyStoredError.number = BADALGORITHM_ERROR Then MyStoredError.Raise
  
End Function

Public Function modifiedSinceSave()

  On Error GoTo oops:
  modifiedSinceSave = True
  
  Dim testConfigForm As GeneralConfigurationClass
  Dim testConfigDB As New GeneralConfigurationClass
  
  Set testConfigForm = FormRead
  
  testConfigDB.SetConfigType trackParametersTC
  testConfigDB.ReadFromDB name:=configuration.GetValue("name")
  
  If testConfigForm.IsEquivalentTo(testConfigDB) Then modifiedSinceSave = False
  
  Exit Function
  
oops:
  ErrorBox

End Function

Public Function NotApplied()

  On Error GoTo oops:
  NotApplied = True
  
  Dim testConfig As GeneralConfigurationClass
 
  Set testConfig = FormRead

  If testConfig.IsEquivalentTo(general.trackerParameter) Then NotApplied = False
  
  Exit Function
  
oops:
  ErrorBox

End Function
